/*
 * Decompiled with CFR 0.152.
 */
package sidblaster.hardsid;

import com.ftdi.FTD2XXException;
import sidblaster.Command;
import sidblaster.CommandEnum;
import sidblaster.ICommandDispatcher;
import sidblaster.SIDType;
import sidblaster.async.AsyncDispatcher;
import sidblaster.d2xx.D2XXManager;
import sidblaster.hardsid.HardSID;
import sidblaster.hardsid.WState;

public class HardSIDImpl
implements HardSID {
    private static final short HARDSID_VERSION = 515;
    private ICommandDispatcher g_CommandDispatcher = new AsyncDispatcher();
    private D2XXManager x_Manager = D2XXManager.getInstance();
    private long startTime;
    private long c64Time;

    public HardSIDImpl() {
        try {
            this.g_CommandDispatcher.initialize();
        }
        catch (FTD2XXException e) {
            e.printStackTrace();
        }
    }

    @Override
    public short HardSID_Version() {
        return 515;
    }

    @Override
    public byte HardSID_Devices() {
        try {
            return (byte)this.g_CommandDispatcher.deviceCount();
        }
        catch (FTD2XXException e) {
            e.printStackTrace();
            return 0;
        }
    }

    @Override
    public void HardSID_Delay(byte DeviceID, short Cycles) {
        this.c64Time += (long)(Cycles & 0xFFFF);
        Command cmd = new Command(DeviceID, CommandEnum.Delay, 0, 0, this.startTime + (long)((double)this.c64Time * 1014.9724678568369));
        try {
            this.g_CommandDispatcher.sendCommand(cmd);
        }
        catch (FTD2XXException | InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void HardSID_Write(byte DeviceID, short Cycles, byte SID_reg, byte data) {
        this.c64Time += (long)(Cycles & 0xFFFF);
        Command cmd = new Command(DeviceID, CommandEnum.Write, SID_reg, data, this.startTime + (long)((double)this.c64Time * 1014.9724678568369));
        try {
            while (this.g_CommandDispatcher.sendCommand(cmd) != 0) {
                Thread.yield();
            }
        }
        catch (FTD2XXException | InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public byte HardSID_Read(byte DeviceID, short Cycles, byte SID_reg) {
        this.c64Time += (long)(Cycles & 0xFFFF);
        Command cmd = new Command(DeviceID, CommandEnum.Read, SID_reg, 0, this.startTime + (long)((double)this.c64Time * 1014.9724678568369));
        try {
            int result = this.g_CommandDispatcher.sendCommand(cmd);
            if (result != 0) {
                return (byte)(result >> 8);
            }
            return 0;
        }
        catch (FTD2XXException | InterruptedException e) {
            e.printStackTrace();
            return 0;
        }
    }

    @Override
    public void HardSID_Flush(byte DeviceID) {
        Command cmd = new Command(DeviceID, CommandEnum.Flush);
        try {
            this.g_CommandDispatcher.sendCommand(cmd);
        }
        catch (FTD2XXException | InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void HardSID_SoftFlush(byte DeviceID) {
        Command cmd = new Command(DeviceID, CommandEnum.SoftFlush);
        try {
            this.g_CommandDispatcher.sendCommand(cmd);
        }
        catch (FTD2XXException | InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean HardSID_Lock(byte DeviceID) {
        Command cmd = new Command(DeviceID, CommandEnum.Lock);
        try {
            this.g_CommandDispatcher.sendCommand(cmd);
            return true;
        }
        catch (FTD2XXException | InterruptedException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public void HardSID_Filter(byte DeviceID, boolean filter) {
        Command cmd = new Command(DeviceID, CommandEnum.Filter, 0, (byte)(filter ? 1 : 0));
        try {
            this.g_CommandDispatcher.sendCommand(cmd);
        }
        catch (FTD2XXException | InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void HardSID_Reset(byte DeviceID) {
        this.c64Time = 0L;
        this.startTime = System.nanoTime();
        Command cmd = new Command(DeviceID, CommandEnum.Reset);
        try {
            this.g_CommandDispatcher.sendCommand(cmd);
        }
        catch (FTD2XXException | InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void HardSID_Sync(byte DeviceID) {
        Command cmd = new Command(DeviceID, CommandEnum.Sync);
        try {
            this.g_CommandDispatcher.sendCommand(cmd);
        }
        catch (FTD2XXException | InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void HardSID_Mute(byte DeviceID, byte voice, boolean mute) {
        if (mute) {
            Command cmd = new Command(DeviceID, CommandEnum.MuteAll, 0, voice);
            try {
                this.g_CommandDispatcher.sendCommand(cmd);
            }
            catch (FTD2XXException | InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void HardSID_MuteAll(byte DeviceID, boolean mute) {
        if (mute) {
            Command cmd = new Command(DeviceID, CommandEnum.MuteAll);
            try {
                this.g_CommandDispatcher.sendCommand(cmd);
            }
            catch (FTD2XXException | InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void InitHardSID_Mapper() {
    }

    @Override
    public byte GetHardSIDCount() {
        return this.HardSID_Devices();
    }

    @Override
    public void WriteToHardSID(byte DeviceID, byte SID_reg, byte data) {
        this.HardSID_Write(DeviceID, (short)0, SID_reg, data);
    }

    @Override
    public byte ReadFromHardSID(byte DeviceID, byte SID_reg) {
        Command cmd = new Command(DeviceID, CommandEnum.Read, SID_reg, 0);
        try {
            return (byte)this.g_CommandDispatcher.sendCommand(cmd);
        }
        catch (FTD2XXException | InterruptedException e) {
            e.printStackTrace();
            return 0;
        }
    }

    @Override
    public void MuteHardSID_Line(boolean mute) {
    }

    @Override
    public void HardSID_Reset2(byte DeviceID, byte volume) {
    }

    @Override
    public void HardSID_Unlock(byte DeviceID) {
        Command cmd = new Command(DeviceID, CommandEnum.Unlock);
        try {
            this.g_CommandDispatcher.sendCommand(cmd);
        }
        catch (FTD2XXException | InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public WState HardSID_Try_Write(byte DeviceID, short Cycles, byte SID_reg, byte data) {
        this.c64Time += (long)(Cycles & 0xFFFF);
        Command cmd = new Command(DeviceID, CommandEnum.Write, SID_reg, data, this.startTime + (long)((double)this.c64Time * 1014.9724678568369));
        try {
            if (this.g_CommandDispatcher.sendCommand(cmd) == 0) {
                return WState.OK;
            }
            return WState.BUSY;
        }
        catch (FTD2XXException | InterruptedException e) {
            e.printStackTrace();
            return WState.ERROR;
        }
    }

    @Override
    public String HardSID_GetSerial(byte DeviceID) {
        return this.x_Manager.GetSerialNo(DeviceID);
    }

    @Override
    public void HardSID_SetWriteBufferSize(byte bufferSize) {
        this.g_CommandDispatcher.setWriteBufferSize(bufferSize);
    }

    @Override
    public void HardSID_SetLatencyTimer(short ms) {
        try {
            this.g_CommandDispatcher.setLatencyTimer(ms);
        }
        catch (FTD2XXException e) {
            e.printStackTrace();
        }
    }

    @Override
    public SIDType HardSID_GetSIDType(byte DeviceID) {
        return this.x_Manager.GetSIDType(DeviceID);
    }

    @Override
    public void HardSID_Uninitialize() {
        try {
            this.g_CommandDispatcher.uninitialize();
        }
        catch (FTD2XXException | InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setDebug(boolean enabled) {
        throw new RuntimeException("N.Y.I.");
    }

    @Override
    public short GetDLLVersion() {
        return 515;
    }

    @Override
    public void MuteHardSID(byte deviceID, byte channel, boolean mute) {
        throw new RuntimeException("N.Y.I.");
    }

    @Override
    public void MuteHardSIDAll(byte deviceID, boolean mute) {
        throw new RuntimeException("N.Y.I.");
    }

    @Override
    public boolean HardSID_Group(byte deviceID, boolean enable, byte groupID) {
        throw new RuntimeException("N.Y.I.");
    }

    @Override
    public void HardSID_Mute2(byte DeviceID, byte channel, boolean mute, boolean manual) {
        throw new RuntimeException("N.Y.I.");
    }

    @Override
    public void HardSID_OtherHardware() {
        throw new RuntimeException("N.Y.I.");
    }

    @Override
    public short HardSID_Clock(byte DeviceID, byte preset) {
        throw new RuntimeException("N.Y.I.");
    }

    @Override
    public int HardSID_SetSIDType(byte DeviceID, SIDType sidType) {
        try {
            this.x_Manager.SetSIDType(DeviceID, sidType);
            return 0;
        }
        catch (FTD2XXException | InterruptedException e) {
            e.printStackTrace();
            return 1;
        }
    }

    @Override
    public int HardSID_SetSerial(byte DeviceID, String serialNo) {
        try {
            this.x_Manager.SetSerialNo(DeviceID, serialNo);
            return 0;
        }
        catch (FTD2XXException | InterruptedException e) {
            e.printStackTrace();
            return 1;
        }
    }
}

